//
//  VungleAdapter.m
//  AdPopcornSSP
//
//  Created by mick on 2019. 3. 19..
//  Copyright (c) 2019년 igaworks All rights reserved.
//

// compatible with Vungle v7.4.1
#import "VungleAdapter.h"

static inline NSString *SSPErrorString(SSPErrorCode code)
{
    switch (code)
    {
        case AdPopcornSSPException:
            return @"Exception";
        case AdPopcornSSPInvalidParameter:
            return @"Invalid Parameter";
        case AdPopcornSSPUnknownServerError:
            return @"Unknown Server Error";
        case AdPopcornSSPInvalidMediaKey:
            return @"Invalid Media key";
        case AdPopcornSSPInvalidPlacementId:
            return @"Invalid Placement Id";
        case AdPopcornSSPMediationInvalidIntegrationKey:
            return @"Invalid Integration Key";
        case AdPopcornSSPInvalidNativeAssetsConfig:
            return @"Invalid native assets config";
        case AdPopcornSSPNativePlacementDoesNotInitialized:
            return @"Native Placement Does Not Initialized";
        case AdPopcornSSPServerTimeout:
            return @"Server Timeout";
        case AdPopcornSSPLoadAdFailed:
            return @"Load Ad Failed";
        case AdPopcornSSPNoAd:
            return @"No Ad";
        case AdPopcornSSPNoInterstitialLoaded:
            return @"No Interstitial Loaded";
        case AdPopcornSSPNoRewardVideoAdLoaded:
            return @"No Reward video ad Loaded";
        case AdPopcornSSPMediationAdapterNotInitialized:
            return @"Mediation Adapter Not Initialized";
        case AdPopcornSSPNoInterstitialVideoAdLoaded:
            return @"No Interstitial video ad Loaded";
        default: {
            return @"Success";
        }
    }
}

@interface VungleAdapter () <VungleBannerDelegate, VungleRewardedDelegate, VungleInterstitialDelegate, VungleNativeDelegate>
{
    BOOL _isCurrentRunningAdapter;
    NSString *vungleAppId, *vungleBannerPlacementId, *vungleRVPlacementId, *vungleIVPlacementId, *vungleNativePlacementId;
    
    VideoMixAdType videoMixAdType;
    NSTimer *networkScheduleTimer;
    NSInteger adNetworkNo;
    NSMutableArray *_impTrackersListArray, *_clickTrackersListArray;
    NSString *_biddingData;
    BOOL _isInAppBidding;
    APVungleNativeAdRenderer *vungleNativeAdRenderer;
}

@property (nonatomic, strong) VungleBanner *bannerAd;
@property (nonatomic, strong) VungleRewarded *rewardedAd;
@property (nonatomic, strong) VungleInterstitial *interstitialAd;
@property (nonatomic, strong) VungleNative *nativeAd;

@end

@implementation VungleAdapter

@synthesize delegate = _delegate;
@synthesize integrationKey = _integrationKey;
@synthesize viewController = _viewController;
@synthesize bannerView = _bannerView;
@synthesize adpopcornSSPNativeAd = _adpopcornSSPNativeAd;

- (instancetype)init
{
    self = [super init];
    if (self){}
    adNetworkNo = 14;
    _isInAppBidding = NO;
    return self;
}

- (void)setViewController:(UIViewController *)viewController origin:(CGPoint)origin size:(CGSize)size bannerView:(AdPopcornSSPBannerView *)bannerView
{
    _viewController = viewController;
    _origin = origin;
    _size = size;
    _bannerView = bannerView;
    _adType = SSPAdBannerType;
}

- (void)setViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPAdInterstitialType;
}

- (void)setRewardVideoViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPRewardVideoAdType;
}

- (void)setInterstitialVideoViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPInterstitialVideoAdType;
}

- (void)setVideoMixAdViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPVideoMixAdType;
}

- (void)setNativeAdViewController:(UIViewController *)viewController nativeAdRenderer:(id)nativeAdRenderer rootNativeAdView:(AdPopcornSSPNativeAd *)adpopcornSSPNativeAd
{
    _viewController = viewController;
    _adType = SSPNativeAdType;
    if([nativeAdRenderer isKindOfClass:[APVungleNativeAdRenderer class]])
        vungleNativeAdRenderer = nativeAdRenderer;
    _adpopcornSSPNativeAd = adpopcornSSPNativeAd;
}

- (BOOL)isSupportInterstitialAd
{
    return NO;
}

- (BOOL)isSupportRewardVideoAd
{
    return YES;
}

- (BOOL)isSupportInterstitialVideoAd
{
    return YES;
}

- (BOOL)isSupportNativeAd
{
    return YES;
}

- (BOOL)isSupportVideoMixAd
{
    return YES;
}

- (void)setBiddingData:(NSString *)biddingData impressionList:(NSMutableArray *)impTrackersListArray clickList: (NSMutableArray *)clickTrackersListArray
{
    _biddingData = biddingData;
    _impTrackersListArray = impTrackersListArray;
    _clickTrackersListArray =  clickTrackersListArray;
}

- (void)setInAppBiddingMode:(bool)isInAppBiddingMode
{
    _isInAppBidding = isInAppBiddingMode;
    NSLog(@"VungleAdapter setInAppBiddingMode : %d", _isInAppBidding);
}

- (void)loadAd
{
    if(_adType == SSPAdBannerType)
    {
        NSLog(@"VungleAdapter %@ : SSPAdBannerType loadAd : %d", self, _isInAppBidding);
        if (_integrationKey != nil)
        {
            if(_size.width == 320.0f && _size.height == 100.0f)
            {
                NSLog(@"%@ : Vungle can not load 320x100", self);
                if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
                {
                    [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
                }
                
                [self closeAd];
                return;
            }
            
            BannerSize bannerSize = BannerSizeRegular;
            if(_size.width == 300.0f && _size.height == 250.0f)
            {
                bannerSize = BannerSizeMrec;
            }
            
            if(_isInAppBidding)
            {
                vungleAppId = @"";
                vungleBannerPlacementId = [_integrationKey valueForKey:@"vungle_placement_id"];
            }
            else
            {
                vungleAppId = [_integrationKey valueForKey:@"VungleAppId"];
                vungleBannerPlacementId = [_integrationKey valueForKey:@"VunglePlacementId"];
            }
            
            if([VungleAds isInitialized])
            {
                NSLog(@"VungleAdapter banner already initialized : %@", vungleBannerPlacementId);
                self.bannerAd = [[VungleBanner alloc] initWithPlacementId:vungleBannerPlacementId size:bannerSize];
                self.bannerAd.delegate = self;
                
                if(_isInAppBidding)
                {
                    [self.bannerAd load:_biddingData];
                }
                else
                {
                    [self.bannerAd load:nil];
                }
            }
            else
            {
                NSLog(@"VungleAdapter banner initWithAppId");
                [VungleAds initWithAppId:vungleAppId completion:^(NSError * _Nullable error) {
                    if (error) {
                        NSLog(@"VungleAdapter banner Error initializing SDK %@", error);
                        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
                        {
                            [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
                        }
                        [self closeAd];
                    } else {
                        NSLog(@"VungleAdapter banner initialized");
                        self.bannerAd = [[VungleBanner alloc] initWithPlacementId:vungleBannerPlacementId size:bannerSize];
                        self.bannerAd.delegate = self;
                        
                        if(_isInAppBidding)
                        {
                            [self.bannerAd load:_biddingData];
                        }
                        else
                        {
                            [self.bannerAd load:nil];
                        }
                    }
                }];
            }
        }
        else
        {
            NSLog(@"VungleAdapter banner no integrationKey");
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            [self invalidateNetworkTimer];
        }
    }
    else if (_adType == SSPRewardVideoAdType)
    {
        NSLog(@"VungleAdapter %@ : SSPRewardVideoAdType loadAd : %d", self, _isInAppBidding);
        if(networkScheduleTimer == nil)
        {
            networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
        }
        else{
            [self invalidateNetworkTimer];
            networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
        }
        
        _isCurrentRunningAdapter = YES;
        if (_integrationKey != nil)
        {
            [self setupRewardVideo:@"rewardVideo"];
        }
        else
        {
            NSLog(@"VungleAdapter rewardVideo no integrationKey");
            if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            [self invalidateNetworkTimer];
        }
    }
    else if(_adType == SSPInterstitialVideoAdType)
    {
        NSLog(@"VungleAdapter %@ : SSPInterstitialVideoAdType loadAd", self);
        if(networkScheduleTimer == nil)
        {
            networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
        }
        else{
            [self invalidateNetworkTimer];
            networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
        }
        _isCurrentRunningAdapter = YES;
        if (_integrationKey != nil)
        {
            [self setupInterstitialVideo:@"InterstitialVideo"];
        }
        else
        {
            NSLog(@"VungleAdapter interstitialVideo no integrationKey");
            if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            [self invalidateNetworkTimer];
        }
    }
    else if(_adType == SSPNativeAdType)
    {
        if (_integrationKey != nil)
        {
            if(_isInAppBidding)
            {
                vungleAppId = @"";
                vungleNativePlacementId = [_integrationKey valueForKey:@"vungle_placement_id"];
            }
            else
            {
                vungleAppId = [_integrationKey valueForKey:@"VungleAppId"];
                vungleNativePlacementId = [_integrationKey valueForKey:@"VunglePlacementId"];
            }
            if (self.nativeAd != nil)
            {
                self.nativeAd.delegate = nil;
                self.nativeAd = nil;
            }
            
            self.nativeAd = [[VungleNative alloc] initWithPlacementId:vungleNativePlacementId];
            self.nativeAd.delegate = self;
            [self.nativeAd load:nil];
        }
        else{
            NSLog(@"VungleAdapter nativeAd no integrationKey");
            if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            [self invalidateNetworkTimer];
        }
    }
    else if(_adType == SSPVideoMixAdType) {
        NSLog(@"VungleAdapter %@ : SSPVideoMixAdType loadAd : %d", self, _isInAppBidding);
        if(networkScheduleTimer == nil)
        {
            networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
        }
        else{
            [self invalidateNetworkTimer];
            networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
        }
        
        _isCurrentRunningAdapter = YES;
        if (_integrationKey != nil) {
            NSNumber *campaignType = [_integrationKey valueForKey:@"CampaignType"];
            NSInteger campaignValue = [campaignType integerValue];
            videoMixAdType = SSPVideoMixAdTypeFromInteger(campaignValue);
            
            // Video Mix Ad Type
            switch (videoMixAdType) {
                case VideoMix_InterstitialType:
                    [self isNotSupport:_adType];
                    break;
                    
                case VideoMix_InterstitialVideoType:
                    [self setupInterstitialVideo:@"VideoMix_InterstitialVideo"];
                    break;
                    
                case VideoMix_RewardVideoType:
                    [self setupRewardVideo:@"VideoMix_RewardVideo"];
                    break;
                    
                default: break;
            }
        }
        else
        {
            NSLog(@"VungleAdapter VideoMix_RewardVideo no integrationKey");
            if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter: videoMixType:)])
            {
                [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self videoMixType:videoMixAdType];
            }
            [self invalidateNetworkTimer];
        }
    }
}

-(void)isNotSupport:(SSPAdType) adType {
    switch (adType) {
        case SSPAdBannerType:
            NSLog(@"VungleAdapter is not support :%u", _adType);
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
            }
            break;
        case SSPNativeAdType:
            NSLog(@"VungleAdapter is not support :%u", _adType);
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
            }
            break;
        case SSPAdInterstitialType:
            NSLog(@"VungleAdapter is not support :%u", _adType);
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterInterstitialAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
            }
            break;
        case SSPInterstitialVideoAdType:
            NSLog(@"VungleAdapter is not support :%u", _adType);
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
            }
            break;
        case SSPRewardVideoAdType:
            NSLog(@"VungleAdapter is not support :%u", _adType);
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
            }
            break;
        case SSPVideoMixAdType:
            NSLog(@"VungleAdapter is not support :%u , videomix: %d", _adType, videoMixAdType);
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter: videoMixType:)])
            {
                [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self videoMixType:videoMixAdType];
            }
            break;
        default:
            break;
    }
}

- (void) setupInterstitial:(NSString*) typeName {
    NSLog(@"dosen't support %@", typeName);
    if (_adType == SSPVideoMixAdType) {
        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter:videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self videoMixType:videoMixAdType];
        }
    } else {
        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
        }
    }
}

- (void) setupInterstitialVideo:(NSString*) typeName {
    NSLog(@"VungleAdapter %@ already initialized : %@", typeName, vungleRVPlacementId);
    
    if(_isInAppBidding)
    {
        vungleAppId = @"";
        vungleIVPlacementId = [_integrationKey valueForKey:@"vungle_placement_id"];
    }
    else
    {
        vungleAppId = [_integrationKey valueForKey:@"VungleAppId"];
        vungleIVPlacementId = [_integrationKey valueForKey:@"VunglePlacementId"];
    }
    
    if([VungleAds isInitialized]) {
        NSLog(@"VungleAdapter interstitialVideo already initialized : %@", vungleIVPlacementId);
        self.interstitialAd = [[VungleInterstitial alloc]     initWithPlacementId:vungleIVPlacementId];
        self.interstitialAd.delegate = self;
        if(_isInAppBidding)
        {
            [self.interstitialAd load:_biddingData];
        }
        else
        {
            [self.interstitialAd load:nil];
        }
    }
    else {
        NSLog(@"VungleAdapter interstitialVideo initWithAppId");
        [VungleAds initWithAppId:vungleAppId completion:^(NSError * _Nullable error) {
            if (error) {
                if (_adType == SSPVideoMixAdType) {
                    NSLog(@"VungleAdapter  %@ initializing error %@", typeName, error);
                    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter:videoMixType:)])
                    {
                        [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self videoMixType:videoMixAdType];
                    }
                } else {
                    NSLog(@"VungleAdapter  %@ initializing error %@", typeName, error);
                    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:adapter:)])
                    {
                        [_delegate AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
                    }
                }
                [self invalidateNetworkTimer];
            } else {
                NSLog(@"VungleAdapter interstitialVideo initialized");
                self.interstitialAd = [[VungleInterstitial alloc]     initWithPlacementId:vungleIVPlacementId];
                self.interstitialAd.delegate = self;
                
                if(_isInAppBidding)
                {
                    [self.interstitialAd load:_biddingData];
                }
                else
                {
                    [self.interstitialAd load:nil];
                }
            }
        }];
    }
}

- (void) setupRewardVideo:(NSString*) typeName {
    if(_isInAppBidding)
    {
        vungleAppId = @"";
        vungleRVPlacementId = [_integrationKey valueForKey:@"vungle_placement_id"];
    }
    else
    {
        vungleAppId = [_integrationKey valueForKey:@"VungleAppId"];
        vungleRVPlacementId = [_integrationKey valueForKey:@"VunglePlacementId"];
    }
    
    if([VungleAds isInitialized]) {
        NSLog(@"VungleAdapter %@ already initialized : %@", typeName, vungleRVPlacementId);
        self.rewardedAd = [[VungleRewarded alloc] initWithPlacementId:vungleRVPlacementId];
//        self.rewardedAd = [[VungleRewarded alloc] initWithPlacementId:@"VIDEO_TICKET_OPEN_FRONT_RV_IOS-9382339"];
            self.rewardedAd.delegate = self;
        
        if(_isInAppBidding)
        {
            [self.rewardedAd load:_biddingData];
        }
        else
        {
            [self.rewardedAd load:nil];
        }
    }
    else {
        NSLog(@"VungleAdapter %@ initWithAppId", typeName);
        [VungleAds initWithAppId:vungleAppId completion:^(NSError * _Nullable error) {
            if (error) {
                if (_adType == SSPVideoMixAdType) {
                    NSLog(@"VungleAdapter  %@ initializing error %@", typeName, error);
                    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter:videoMixType:)])
                    {
                        [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self videoMixType:videoMixAdType];
                    }
                } else {
                    NSLog(@"VungleAdapter  %@ initializing error %@", typeName, error);
                    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
                    {
                        [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
                    }
                }
                [self invalidateNetworkTimer];
            } else {
                NSLog(@"VungleAdapter  %@ initialized", typeName);
                self.rewardedAd = [[VungleRewarded alloc] initWithPlacementId:vungleRVPlacementId];
                self.rewardedAd.delegate = self;
                
                if(_isInAppBidding)
                {
                    [self.rewardedAd load:_biddingData];
                }
                else
                {
                    [self.rewardedAd load:nil];
                }
            }
        }];
    }
}


- (void)showAd
{
    NSLog(@"VungleAdapter : showAd : %d", _adType);
    if (_adType == SSPRewardVideoAdType) {
        [self.rewardedAd presentWith:_viewController];
    }
    else if(_adType == SSPInterstitialVideoAdType) {
        [self.interstitialAd presentWith:_viewController];
    }
    else if(_adType == SSPVideoMixAdType) {
        switch (videoMixAdType) {
            case VideoMix_InterstitialType: // 지원 안함
                break;
                
            case VideoMix_InterstitialVideoType:
                [self.interstitialAd presentWith:_viewController];
                break;
                
            case VideoMix_RewardVideoType:
                [self.rewardedAd presentWith:_viewController];
                break;
                
            default: break;
        }
        
    }
}

- (void)closeAd
{
    NSLog(@"VungleAdapter closeAd");
    if(_adType == SSPAdBannerType)
    {
        for (id subview in _bannerView.subviews) {
            [subview removeFromSuperview];
        }
        self.bannerAd.delegate = nil;
        self.bannerAd = nil;
    }
    else if(_adType == SSPNativeAdType)
    {
        [self.nativeAd unregisterView];
    }
    else{
        _isCurrentRunningAdapter = NO;
        [self invalidateNetworkTimer];
    }
}

- (void)loadRequest
{
    // Not used any more
}

-(void)networkScheduleTimeoutHandler:(NSTimer*) timer
{
    if(_adType == SSPRewardVideoAdType)
    {
        NSLog(@"VungleAdapter rewardVideo load timeout");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
        }
    }
    else if(_adType == SSPInterstitialVideoAdType)
    {
        NSLog(@"VungleAdapter interstitialVideo load timeout");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
        }
    }
    else if(_adType == SSPVideoMixAdType) {
        NSLog(@"VungleAdapter VideoMixAd load timeout");
        switch (videoMixAdType) {
            case VideoMix_InterstitialType:
                break;
                
            default:
                if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter:videoMixType:)])
                {
                    [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self videoMixType:videoMixAdType];
                }
                break;
        }

    }
    [self invalidateNetworkTimer];
}

-(void)invalidateNetworkTimer
{
    if(networkScheduleTimer != nil)
        [networkScheduleTimer invalidate];
}

#pragma mark - VungleBanner Delegate Methods
- (void)bannerAdDidLoad:(VungleBanner *)banner {
    NSLog(@"VungleAdapter bannerAdDidLoad");
    [self.bannerAd presentOn:_bannerView];
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewLoadSuccess:self];
    }
}
- (void)bannerAdDidFailToLoad:(VungleBanner *)banner
                    withError:(NSError *)withError {
    NSLog(@"VungleAdapter bannerAdDidFailToLoad");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
    }
    [self closeAd];
}
- (void)bannerAdDidPresent:(VungleBanner *)banner {
    NSLog(@"VungleAdapter bannerAdDidPresent");
}
- (void)bannerAdDidFailToPresent:(VungleBanner *)banner
                       withError:(NSError *)withError {
    NSLog(@"VungleAdapter bannerAdDidFailToPresent");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
    }
    [self closeAd];
}
- (void)bannerAdDidTrackImpression:(VungleBanner *)banner {
    NSLog(@"VungleAdapter bannerAdDidTrackImpression");
    for(NSString *url in _impTrackersListArray)
    {
        if ([_delegate respondsToSelector:@selector(impClickTracking:)])
        {
            [_delegate impClickTracking:url];
        }
    }
}
- (void)bannerAdDidClick:(VungleBanner *)banner {
    NSLog(@"VungleAdapter bannerAdDidClick");
    for(NSString *url in _clickTrackersListArray)
    {
        if ([_delegate respondsToSelector:@selector(impClickTracking:)])
        {
            [_delegate impClickTracking:url];
        }
    }
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewClicked:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewClicked:self];
    }
}
- (void)bannerAdDidClose:(VungleBanner *)banner {
    NSLog(@"bannerAdDidClose");
}

#pragma mark - VungleRewarded Delegate Methods
// Ad load events
- (void)rewardedAdDidLoad:(VungleRewarded *)rewarded {
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidLoad");
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadSuccess: videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdLoadSuccess:self videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidLoad");
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadSuccess:)])
        {
            [_delegate AdPopcornSSPAdapterRewardVideoAdLoadSuccess:self];
        }
    }
}
- (void)rewardedAdDidFailToLoad:(VungleRewarded *)rewarded
                      withError:(NSError *)withError {
    
    // VideoMixAd 일 경우
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidFailToLoad %@", withError);
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter: videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidFailToLoad %@", withError);
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
        }
    }
}
// Ad Lifecycle Events
- (void)rewardedAdDidPresent:(VungleRewarded *)rewarded {
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdShowSuccess: videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdShowSuccess:self videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdShowSuccess:)])
        {
            [_delegate AdPopcornSSPAdapterRewardVideoAdShowSuccess:self];
        }
    }
}
- (void)rewardedAdDidFailToPresent:(VungleRewarded *)rewarded
                         withError:(NSError *)withError {
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidFailToPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdShowFailError:adapter: videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdShowFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPNoRewardVideoAdLoaded userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPNoRewardVideoAdLoaded)}] adapter:self videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidFailToPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdShowFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterRewardVideoAdShowFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPNoRewardVideoAdLoaded userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPNoRewardVideoAdLoaded)}] adapter:self];
        }
    }
}
- (void)rewardedAdDidTrackImpression:(VungleRewarded *)rewarded {
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidTrackImpression");
        for(NSString *url in _impTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidTrackImpression");
        for(NSString *url in _impTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    }
    
}
- (void)rewardedAdDidClick:(VungleRewarded *)rewarded {
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidClick");
        for(NSString *url in _clickTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidClick");
        for(NSString *url in _clickTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    }
}
- (void)rewardedAdWillLeaveApplication:(VungleRewarded *)rewarded {
    NSLog(@"VungleAdapter rewardedAdWillLeaveApplication");
}

- (void)rewardedAdDidRewardUser:(VungleRewarded *)rewarded {
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidRewardUser");
        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdCompleteTrackingEvent:isCompleted: videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdCompleteTrackingEvent:adNetworkNo isCompleted:YES videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidRewardUser");
        if ([_delegate respondsToSelector:@selector(onCompleteTrackingEvent:isCompleted:)])
        {
            [_delegate onCompleteTrackingEvent:adNetworkNo isCompleted:YES];
        }
    }
}
- (void)rewardedAdDidClose:(VungleRewarded *)rewarded {
    if (videoMixAdType == VideoMix_RewardVideoType) {
        NSLog(@"VungleAdapter VideoMix_RewardVideo DidClose");
        _isCurrentRunningAdapter = NO;
        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdClose: videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdClose:self videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter rewardedAdDidClose");
        _isCurrentRunningAdapter = NO;
        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdClose:)])
        {
            [_delegate AdPopcornSSPAdapterRewardVideoAdClose:self];
        }
    }
}

#pragma mark - VungleInterstitial Delegate Methods
// Ad load events
- (void)interstitialAdDidLoad:(VungleInterstitial *)interstitial {
    if (videoMixAdType == VideoMix_InterstitialVideoType) {
        NSLog(@"VungleAdapter VideoMix_InterstitialVideo DidLoad");
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadSuccess:videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdLoadSuccess:self videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter interstitialAdDidLoad");
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdLoadSuccess:)])
        {
            [_delegate AdPopcornSSPAdapterInterstitialVideoAdLoadSuccess:self];
        }
    }
}

- (void)interstitialAdDidFailToLoad:(VungleInterstitial *)interstitial
                          withError:(NSError *)withError {
    if (videoMixAdType == VideoMix_InterstitialVideoType) {
        NSLog(@"VungleAdapter VideoMix_InterstitialVideoDidFailToLoad");
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdLoadFailError:adapter:videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self videoMixType:videoMixAdType];
        }
    } else {
        NSLog(@"VungleAdapter interstitialAdDidFailToLoad");
        [self invalidateNetworkTimer];
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterInterstitialVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
        }
    }
}

// Ad Lifecycle Events
- (void)interstitialAdDidPresent:(VungleInterstitial *)interstitial {
    if (videoMixAdType == VideoMix_InterstitialVideoType) {
        NSLog(@"VungleAdapter VideoMix_interstitialAdDidPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdShowSuccess:videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdShowSuccess:self videoMixType:videoMixAdType];
        }
    }
    else {
        NSLog(@"VungleAdapter interstitialAdDidPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdShowSuccess:)])
        {
            [_delegate AdPopcornSSPAdapterInterstitialVideoAdShowSuccess:self];
        }
    }

}
- (void)interstitialAdDidFailToPresent:(VungleInterstitial *)interstitial
                             withError:(NSError *)withError {
    if (videoMixAdType == VideoMix_InterstitialVideoType) {
        NSLog(@"VungleAdapter VideoMix_interstitialAdDidFailToPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdShowFailError:adapter:videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdShowFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPNoInterstitialVideoAdLoaded userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPNoInterstitialVideoAdLoaded)}] adapter:self videoMixType:videoMixAdType];
        }
    }
    else {
        NSLog(@"VungleAdapter interstitialAdDidFailToPresent");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdShowFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterInterstitialVideoAdShowFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPNoInterstitialVideoAdLoaded userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPNoInterstitialVideoAdLoaded)}] adapter:self];
        }
    }
}
- (void)interstitialAdDidTrackImpression:(VungleInterstitial *)interstitial {
    if (videoMixAdType == VideoMix_InterstitialVideoType) {
        NSLog(@"VungleAdapter VideoMix_interstitialAdDidTrackImpression");
        for(NSString *url in _impTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    }
    else {
        NSLog(@"VungleAdapter interstitialAdDidTrackImpression");
        for(NSString *url in _impTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    }
}
- (void)interstitialAdDidClick:(VungleInterstitial *)interstitial {
    if (videoMixAdType == VideoMix_InterstitialVideoType) {
        NSLog(@"VungleAdapter interstitialAdDidClick");
        for(NSString *url in _clickTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    }
    else {
        NSLog(@"VungleAdapter interstitialAdDidClick");
        for(NSString *url in _clickTrackersListArray)
        {
            if ([_delegate respondsToSelector:@selector(impClickTracking:)])
            {
                [_delegate impClickTracking:url];
            }
        }
    }
}

- (void)interstitialAdWillLeaveApplication:(VungleInterstitial *)interstitial {
    NSLog(@"VungleAdapter interstitialAdWillLeaveApplication");
}

- (void)interstitialAdDidClose:(VungleInterstitial *)interstitial {
    if (videoMixAdType == VideoMix_InterstitialVideoType) {
        NSLog(@"VungleAdapter interstitialAdDidClose");
        _isCurrentRunningAdapter = NO;
        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterVideoMixAdClose:videoMixType:)])
        {
            [_delegate AdPopcornSSPAdapterVideoMixAdClose:self videoMixType:videoMixAdType];
        }
    }
    else {
        NSLog(@"VungleAdapter interstitialAdDidClose");
        _isCurrentRunningAdapter = NO;
        if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialVideoAdClose:)])
        {
            [_delegate AdPopcornSSPAdapterInterstitialVideoAdClose:self];
        }
    }
}

#pragma mark - VungleNative Deleagate Methods
- (void)nativeAdDidLoad:(VungleNative *)native {
    NSLog(@"VungleAdapter nativeAdDidLoad");
    if(vungleNativeAdRenderer.titleLbl != nil)
    {
        vungleNativeAdRenderer.titleLbl.text = self.nativeAd.title;
    }
    
    if(vungleNativeAdRenderer.ratingLbl != nil)
    {
        vungleNativeAdRenderer.ratingLbl.text = [NSString stringWithFormat:@"Rating: %f", self.nativeAd.adStarRating > 0 ? self.nativeAd.adStarRating : 0];
    }
    
    if(vungleNativeAdRenderer.sponsorLbl != nil)
    {
        vungleNativeAdRenderer.sponsorLbl.text = self.nativeAd.sponsoredText;
    }
    
    if(vungleNativeAdRenderer.adTextLbl != nil)
    {
        vungleNativeAdRenderer.adTextLbl.text = self.nativeAd.bodyText;
    }
    
    if(vungleNativeAdRenderer.downloadBtn != nil)
    {
        [vungleNativeAdRenderer.downloadBtn setTitle:self.nativeAd.callToAction forState:UIControlStateNormal];
    }

    self.nativeAd.adOptionsPosition = NativeAdOptionsPositionTopRight;
    [self.nativeAd registerViewForInteractionWithView:vungleNativeAdRenderer.nativeAdView
                                              mediaView:vungleNativeAdRenderer.mediaView
                                          iconImageView:vungleNativeAdRenderer.iconView
                                         viewController:_viewController
                                         clickableViews:@[vungleNativeAdRenderer.iconView,
                                                          vungleNativeAdRenderer.downloadBtn,
                                                          vungleNativeAdRenderer.titleLbl,
                                                          vungleNativeAdRenderer.adTextLbl,
                                                          vungleNativeAdRenderer.nativeAdView]];
    
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdLoadSuccess:self];
    }
}

- (void)nativeAdDidFailToLoad:(VungleNative *)native
                    withError:(NSError *)withError {
    NSLog(@"VungleAdapter nativeAdDidFailToLoad : %@", withError);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:withError adapter:self];
    }
}

- (void)nativeAdDidFailToPresent:(VungleNative *)native
                       withError:(NSError *)withError {
    NSLog(@"Vungle5dapter nativeAdDidFailToPresent : %@", withError);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:withError adapter:self];
    }
}

- (void)nativeAdDidTrackImpression:(VungleNative *)native {
    NSLog(@"VungleAdapter nativeAdDidTrackImpression");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdImpression:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdImpression:self];
    }
}

- (void)nativeAdDidClick:(VungleNative *)native {
    NSLog(@"VungleAdapter nativeAdDidClick");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdClicked:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdClicked:self];
    }
}

- (NSString *)getBiddingToken
{
    return [VungleAds getBiddingToken];
}

@end

@implementation APVungleNativeAdRenderer
{
}

- (instancetype)init
{
    self = [super init];
    if(self)
    {
    }
    return self;
}
@end
